% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desolve.R
\name{desolve.classified}
\alias{desolve.classified}
\title{Desolve Guide for Classified}
\usage{
\method{desolve}{classified}(x, ...)
}
\arguments{
\item{x}{classified}

\item{...}{passed to \code{\link{drop_title}}, \code{\link{unclassified}}, and \code{\link{unclassified}}}
}
\value{
dvec
}
\description{
Un-resolves explicit usage of default key 'guide' to
implicit usage for class 'classified'.
Calls 
\code{\link{drop_title}} (a non-action by default),
\code{\link{unclassified}},
followed by \code{\link{implicit_guide}}.
}
\examples{
library(magrittr)
x <- as_dvec(
  4:6, 
  guide = list(a = 4L, b = 5L, c = 6L)
)

# untouched
x \%>\% str

# resolved
x \%>\% resolve \%>\% str

# resolved and desolved
x \%>\% resolve \%>\% desolve \%>\% str
}
\seealso{
Other resolve: 
\code{\link{desolve.decorated}()},
\code{\link{desolve.dvec}()},
\code{\link{desolve_generic}},
\code{\link{resolve.classified}()},
\code{\link{resolve.decorated}()},
\code{\link{resolve.dvec}()},
\code{\link{resolve_generic}}

Other classified: 
\code{\link{[.classified}()},
\code{\link{[<-.classified}()},
\code{\link{[[.classified}()},
\code{\link{[[<-.classified}()},
\code{\link{as.integer.classified}()},
\code{\link{c.classified}()},
\code{\link{classified.classified}()},
\code{\link{classified.data.frame}()},
\code{\link{classified.default}()},
\code{\link{classified.dvec}()},
\code{\link{classified.factor}()},
\code{\link{classified_generic}},
\code{\link{unclassified.classified}()},
\code{\link{unclassified.data.frame}()},
\code{\link{unclassified}()}
}
\concept{classified}
\concept{resolve}
