% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xc_index.R
\name{xc_index}
\alias{xc_index}
\title{xc_index}
\usage{
xc_index(
  df,
  kw,
  cat,
  id,
  cit,
  type = "h",
  kdlm = ";",
  cdlm = ";",
  plot = FALSE
)
}
\arguments{
\item{df}{Data frame object containing bibliometric data. This data frame must have at least three columns: one for keywords, one for unique IDs, and one for citation counts. Each row in the data frame should represent a document or publication.}

\item{kw}{Character string specifying the name of the column in "df" that contains keywords. Each cell in this column may contain no keywords (missing), a single keyword or multiple keywords separated by a specified delimiter.}

\item{cat}{Character string specifying the name of the column in "df" that contains categories. Each cell in this column may contain no categories (missing), a single category or multiple categories separated by a specified delimiter.}

\item{id}{Character string specifying the name of the column in "df" that contains unique identifiers for each document. Each cell in this column must contain a single ID (unless missing) and not multiple IDs.}

\item{cit}{Character string specifying the name of the column in "df" that contains the number of citations each document has received. Citations must be represented as integers. Each cell in this column should contain a single integer value (unless missing) representing the citation count for the corresponding document.}

\item{type}{"h" for Hirsch's h-type index or "g" for Egghe's g-type index. Default set to "h".}

\item{kdlm}{Character string specifying the delimiter used in the "kw" column to separate multiple keywords within a single cell. The delimiter should be consistent across the entire "kw" column. Common delimiters include ";", "/", ":", and ",". The default delimiter is set to ";".}

\item{cdlm}{Character string specifying the delimiter used in the "cat" column to separate multiple categories within a single cell. The delimiter should be consistent across the entire "cat" column. Common delimiters include ";", "/", ":", and ",". The default delimiter is set to ";".}

\item{plot}{Logical value indicating whether to generate and display a plot of the xc-index calculation. Set to "TRUE" or "T" to generate the plot, and "FALSE" or "F" to skip plot generation. The default is "FALSE".}
}
\value{
xc-index value and plot for institution.
}
\description{
This is a standalone function that specifically calculates the xc-index for an institution using bibliometric data from an edge list, with an optional plot visualisation. The function is suitable for including inside loops when plotting parameter is set to "FALSE" or "F".
}
\examples{
# Create an example data frame
dat <- data.frame(citations = c(0, 1, 1, 2, 3, 5, 8),
                   keywords = c("a; b; c", "b; d", "c", "d", "e; g", "f", "g"),
                   id = c("abc123", "bcd234", "def345", "efg456", "fgh567", "ghi678", "hij789"),
                   categories = c("a; d; e", "b", "c", "d; g", "e", "f", "g"))
# Calculate g-type xc-index
xc_index(df = dat, kw = "keywords", cat = "categories", id = "id", cit = "citations", type = "g")
# Calculate h-type xc-index and produce plot
xc_index(df = dat, kw = "keywords", cat = "categories", id = "id", cit = "citations", plot = TRUE)
}
