% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module1_irt_utils.R
\name{irt_rescale_3pl}
\alias{irt_rescale_3pl}
\title{Rescale 3PL parameters}
\usage{
irt_rescale_3pl(x, parameter = c("theta", "b"), mean = 0, sd = 1)
}
\arguments{
\item{x}{an IRT model object}

\item{parameter}{the rescaling parameter}

\item{mean}{the mean of the new scale}

\item{sd}{the standard deviation of the new scale}
}
\description{
Rescale parameters in a 3PL model
}
\examples{
# rescale theta
x <- irt_model("3pl")$gendata(20, 5)
c(mean(x$people$theta), sd(x$people$theta))
y <- irt_rescale_3pl(x, "theta", 0, 1)
c(mean(y$people$theta), sd(y$people$theta))
round(abs(irt_stats(x, "prob") - irt_stats(y, "prob")), 2)
# rescale b
x <- irt_model("3pl")$gendata(20, 5)
c(mean(x$items$b), sd(x$items$b))
y <- irt_rescale_3pl(x, "b", 0, 1)
c(mean(y$items$b), sd(y$items$b))
round(abs(irt_stats(x, "prob") - irt_stats(y, "prob")), 2)
}

