% Xpose 4
% An R-based population pharmacokinetic/
% pharmacodynamic model building aid for NONMEM.
% Copyright (C) 1998-2004 E. Niclas Jonsson and Mats Karlsson.
% Copyright (C) 2005-2008 Andrew C. Hooker, Justin J. Wilkins, 
% Mats O. Karlsson and E. Niclas Jonsson.
% Copyright (C) 2009-2010 Andrew C. Hooker, Mats O. Karlsson and 
% E. Niclas Jonsson.

% This file is a part of Xpose 4.
% Xpose 4 is free software; you can redistribute it and/or
% modify it under the terms of the GNU Lesser General Public License
% as published by the Free Software Foundation, either version 3
% of the License, or (at your option) any later version.

% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU Lesser General Public License for more details.

% You should have received a copy of the GNU Lesser General Public License
% along with this program.  A copy can be cound in the R installation
% directory under \share\licenses. If not, see http://www.gnu.org/licenses/.
\name{bootscm.import}
\alias{bootscm.import}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Import bootscm data into R/Xpose
}
\description{
This function imports data generated by the PsN boot_scm function into
the Xpose / R environment.
}
\usage{
bootscm.import(scm.folder = NULL, silent = FALSE, n.bs = NULL,
cov.recoding = NULL, group.by.cov=NULL, skip.par.est.import=FALSE,
dofv.forward = 3.84, dofv.backward = 6.64)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{scm.folder}{
    The folder in which the PsN-generated bootscm data are.
  }
  \item{silent}{
    Don't output any progress report. Default is FALSE.
  }
  \item{n.bs}{
    The number of bootstraps performed. Defaults to 100.
  }
  \item{cov.recoding}{ For categorical covariates that are recoded to
    dichotomous covariates within the bootscm configuration file, a list
    can be specified containing data frames for recoding. See the example
    below for details.  }
  \item{group.by.cov}{Group inclusion frequencies by covariate, instead
    of calculating them per parameter-covariates relationship. Default
    is NULL, which means that the user will be asked to make a choice.}
  \item{skip.par.est.import}{Skip the import of all parameter estimates
    (in each final model in all scm's, as well as parameter estimates in
    first step of each scm). These data are required to make plot that
    show inclusion bias and correlation in parameter
    estimates. Importing these data takes a bit of time (may take a
    minute or so), so if you don't intend to make these plots anyhow this
    step can be skipped. Default is FALSE.}
  \item{dofv.forward}{dOFV value used in forward step of scm.}
  \item{dofv.backward}{dOFV value used in backward step of scm.}
}
%\details{
%%  ~~ If necessary, more details than the description above ~~
%}
\author{
  Ron Keizer
}
%\note{
%}
%% ~Make other sections like Warning with \section{Warning }{....} ~
%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~bootscm }
