% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion.R
\name{ind_roc}
\alias{ind_roc}
\title{Individual ROC plots}
\usage{
ind_roc(
  xpdb,
  mapping = NULL,
  cutpoint = 1,
  type = "ca",
  title = "Individual ROC curves | @run",
  subtitle = "Ofv: @ofv, Eps shrink: @epsshk",
  caption = "@dir | Page @page of @lastpage",
  tag = NULL,
  facets,
  .problem,
  quiet,
  ...
)
}
\arguments{
\item{xpdb}{<\code{xp_xtras}> or <\code{xpose_data}> object}

\item{mapping}{\code{ggplot2} style mapping}

\item{cutpoint}{<\code{numeric}> Of defined probabilities, which one to
use in plots.}

\item{type}{See Details.}

\item{title}{Plot title}

\item{subtitle}{Plot subtitle}

\item{caption}{Plot caption}

\item{tag}{Plot tag}

\item{facets}{Additional facets}

\item{.problem}{Problem number}

\item{quiet}{Silence extra debugging output}

\item{...}{Any additional aesthetics.}
}
\value{
The desired plot
}
\description{
To identify any individual likelihood predictions that may
be more influential or unusual.

Note this function may have a long runtime.
}
\details{
For type-based customization of plots:
\itemize{
\item \code{c} ROC curve (using \code{geom_path})
\item \code{k} Key points on ROC curve (where on curve the
threshold is \code{thres_fixed}) (using \code{geom_point})
\item \code{p} ROC space points (using \code{geom_point})
\item \code{t} ROC space text (using \code{geom_text})
\item \code{a} AUC in bottom right (using \code{geom_label})
}
}
\examples{
\dontrun{
vismo_pomod  \%>\%
  set_var_types(.problem=1, catdv=DV, dvprobs=matches("^P\\\\d+$")) \%>\%
  set_dv_probs(.problem=1, 0~P0,1~P1,ge(2)~P23) \%>\%
  ind_roc()
}
}
