% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/coi_um.R
\name{est.coi.um}
\alias{est.coi.um}
\title{Estimate the coincidence as a function of micron distance}
\usage{
est.coi.um(xoloc, sclength, centromeres, group, intwindow = 0.05, coiwindow,
  intloc, coiloc)
}
\arguments{
\item{xoloc}{list of crossover locations (in microns) for each of several oocytes or spermatocytes.}

\item{sclength}{vector of SC lengths (in microns).}

\item{centromeres}{vector of centromere locations (in microns). If missing, taken to be \code{sclength/2}.}

\item{group}{nominal vector of groups; the intensity function of
the crossover process will be estimated separately for each group,
but a joint coincidence function will be estimated.}

\item{intwindow}{Window size used to smooth the estimated intensity
function.}

\item{coiwindow}{Window size used to smooth the estimated
coincidence function.}

\item{intloc}{Locations at which to estimate the intensity
function, in the interval [0,1]}

\item{coiloc}{Values at which the coincidence function is to be
estimated, in microns, less than \code{max(sclength)}}
}
\value{
A list containing the estimated coincidence (as a matrix
with two columns, micron distance and corresponding estimated
coincidence) and the estimated intensity functions (as a matrix
with \code{length(group)+1} columns (the locations at which the
intensity functions were estimated followed by the group-specific estimates).
}
\description{
Estimate the coincidence as a function of micron distance, with
data on XO locations in microns plus SC length in microns.
}
\details{
The coincidence function is the probability of a recombination
event in both of two intervals, divided by the product of the two
intensity function for the two intervals.

We estimate this as a function of the distance between the two
intervals in microns, taking account of varying SC lengths,.
}
\examples{
# simple example using data simulated with no crossover interference
ncells <- 1000
L <- 2                      # chr lengths in Morgans (constant here)
nchi <- rpois(ncells, 2*L)  # number of chiasmata
xoloc <- lapply(nchi, function(a) runif(a, 0, L)) # chi locations
coi <- est.coi.um(xoloc, rep(L, ncells))

# plot estimated coincidence and intensity
#    (intensity is after scaling chromosome to length 1)
par(mfrow=c(2,1), las=1)
plot(coi$coincidence, type="l", lwd=2, ylim=c(0, max(coi$coincidence[,2])))
plot(coi$intensity, type="l", lwd=2, ylim=c(0, max(coi$intensity[,2])))
}
\author{
Karl W Broman, \email{kbroman@biostat.wisc.edu}
}
\seealso{
\code{\link{gammacoi}}, \code{\link{stahlcoi}},
\code{\link{kfunc}}, \code{\link{est.coi}}
}
\keyword{models}

