% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/loss.R
\name{loss}
\alias{loss}
\alias{loss,tskrr-method}
\alias{loss,tskrrTune-method}
\alias{loss,permtest-method}
\title{Calculate or extract the loss of a tskrr model}
\usage{
loss(x, ...)

\S4method{loss}{tskrr}(
  x,
  fun = loss_mse,
  exclusion = c("interaction", "row", "column", "both"),
  replaceby0 = FALSE,
  predictions = FALSE,
  ...
)

\S4method{loss}{tskrrTune}(
  x,
  fun = loss_mse,
  exclusion = c("interaction", "row", "column", "both"),
  replaceby0 = FALSE,
  predictions = FALSE,
  ...
)

\S4method{loss}{permtest}(x, ...)
}
\arguments{
\item{x}{a model that inherits from class
\code{\link[xnet:tskrr-class]{tskrr}}}

\item{...}{extra arguments passed to the loss function in \code{fun}.}

\item{fun}{a function to be used for calculating the loss. This
can also be a character value giving the name of one of the loss
functions provided in the package}

\item{exclusion}{a character value with possible values "interaction",
"row", "column" or "both".
See also \code{\link{loo}} for more information.}

\item{replaceby0}{a logical value indicating whether the interaction
should be simply removed (\code{FALSE}) or replaced by 0 (\code{TRUE}).}

\item{predictions}{a logical value to indicate whether the
predictions should be used instead of leave one out crossvalidation.
If set to \code{TRUE}, the other arguments are ignored.}
}
\value{
a numeric value with the calculated loss
}
\description{
This function allows calculating the loss of a tskrr model using
either one of the functions defined in \code{\link{loss_functions}}
or a custom user function. If the model inherits from class
\code{\link[xnet:tskrrTune-class]{tskrrTune}} and no additional arguments
are given, the loss is returned for the settings used when tuning.
The function can also be used to extract the original loss from a
\code{\link[xnet:permtest-class]{permtest}} object.
}
\examples{
data(drugtarget)

mod <- tskrr(drugTargetInteraction, targetSim, drugSim)

loss(mod, fun = loss_auc)

tuned <- tune(mod, fun = loss_auc)

loss(tuned)
loss(tuned, fun = loss_mse)

}
\seealso{
\itemize{
\item \code{\link{loss_functions}} for possible loss functions
\item \code{\link{tune}} for tuning a model based on loss functions
}
}
