% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters_permtest.R
\name{permutations}
\alias{permutations}
\alias{Extract-permtest}
\alias{[,permtest-method}
\title{Getters for permtest objects}
\usage{
permutations(x)

\S4method{[}{permtest}(x, i)
}
\arguments{
\item{x}{a \code{\link[xnet:permtest-class]{permtest}} object}

\item{i}{either a numeric vector, a logical vector or a character
vector with the elements that need extraction.}
}
\value{
the requested values
}
\description{
The functions described here are convenience functions to get
information out of a \code{\link[xnet:permtest-class]{permtest}}
object.
}
\examples{

data(drugtarget)

mod <- tskrr(drugTargetInteraction, targetSim, drugSim)
ptest <- permtest(mod, fun = loss_auc)

loss(ptest)
ptest[c(2,3)]
permutations(ptest)

}
\seealso{
\code{\link{loss}} to extract the original loss value.
}
