% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalGene.R
\name{EvalGeneR}
\alias{EvalGeneR}
\title{Evaluates a repaired gene in a problem environment.}
\usage{
EvalGeneR(gene, lF)
}
\arguments{
\item{gene}{A gene.}

\item{lF}{The local configuration of the genetic algorithm.}
}
\value{
A gene (with \code{$evaluated==TRUE}).
}
\description{
\code{EvalGeneR} evaluates a repaired gene in
             a problem environment.
}
\details{
If the decoder repairs a gene, the repaired gene 
         must replace the original gene.
}
\examples{
Parabola2D<-Parabola2DFactory()
lF<-NewlFevalGenes(Parabola2D)
g1<-list(evaluated=FALSE, fit=0, gene1=c(1.0, -1.5, 3.37))
g2<-list(evaluated=FALSE, fit=0, gene1=c(0.0, 0.0, 0.0))
EvalGeneR(g1, lF)
EvalGeneR(g2, lF)
}
\seealso{
EvalGeneU

Other Evaluation Functions: 
\code{\link{EvalGeneDet}()},
\code{\link{EvalGeneStoch}()},
\code{\link{EvalGeneU}()},
\code{\link{EvalGene}()}
}
\concept{Evaluation Functions}
