% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anno.R
\name{xQTLanno_enrich}
\alias{xQTLanno_enrich}
\title{enrichment analysis for GWAS / QTL signals in functional elements, including enhancer, promoter, CPG, and TFs}
\usage{
xQTLanno_enrich(
  snpInfo = "",
  genomeVersion = "hg38",
  enrichElement = "Promoter",
  distLimit = 1e+06
)
}
\arguments{
\item{snpInfo}{A data.table/data.frame with three columns: chromosome, position and p-value.}

\item{genomeVersion}{"hg38" (default) or "hg19". Note: hg19 will be converted to hg38 automatically.}

\item{enrichElement}{"Promoter", "Enhancer" or "TF".}

\item{distLimit}{Defaults: 1e6}
}
\value{
A data.table object
}
\description{
enrichment analysis for GWAS / QTL signals in functional elements, including enhancer, promoter, CPG, and TFs
}
\examples{
\donttest{
url1 <- "https://github.com/dingruofan/exampleData/raw/master/gwas/gwasSub.txt.gz"
snpInfo <- data.table::fread(url1, sep="\t")
enrichHits <- xQTLanno_enrich(snpInfo,enrichElement="Enhancer")
}
}
