% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VectorizeM.R
\name{parLapplyLBm}
\alias{parLapplyLBm}
\title{Memoizing wrapper for parLapplyLB}
\usage{
parLapplyLBm(cl = NULL, X, fun, ..., chunk.size = NULL)
}
\arguments{
\item{cl}{cluster object}

\item{X}{list or vector of inputs}

\item{fun}{function to apply}

\item{...}{additional arguments passed to lapply}

\item{chunk.size}{passed to \code{parallel::parLapplyLB}}
}
\value{
list of results.
}
\description{
Memoizing wrapper for parLapplyLB
}
\examples{

if(requireNamespace("parallel", quietly = TRUE)) {
  cl <- parallel::makeCluster(2)
  fs <- function(x) { x <- x[[1]]; Sys.sleep(1); sin(x) }
  # without memoization should take 1000 seconds
  lst <- parLapplyLBm(cl, c(rep(0, 1000), rep(1, 1000)), fs)
  parallel::stopCluster(cl)
}

}
\seealso{
\code{\link[parallel]{parLapplyLB}}, \code{\link{lapplym}}, \code{\link{VectorizeM}}, \code{\link{vapplym}}
}
