% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grepdf.R
\name{grepdf}
\alias{grepdf}
\title{Grep for column names from a \code{data.frame}}
\usage{
grepdf(pattern, x, ..., ignore.case = FALSE, perl = FALSE,
  value = FALSE, fixed = FALSE, useBytes = FALSE, invert = FALSE)
}
\arguments{
\item{pattern}{passed to \code{\link[base]{grep}}}

\item{x}{data.frame to work with}

\item{...}{force later arguments to be passed by name}

\item{ignore.case}{passed to \code{\link[base]{grep}}}

\item{perl}{passed to \code{\link[base]{grep}}}

\item{value}{passed to \code{\link[base]{grep}}}

\item{fixed}{passed to \code{\link[base]{grep}}}

\item{useBytes}{passed to \code{\link[base]{grep}}}

\item{invert}{passed to \code{\link[base]{grep}}}
}
\value{
column names of x matching grep condition.
}
\description{
Grep for column names from a \code{data.frame}
}
\examples{


d <- data.frame(xa=1, yb=2)

# starts with
grepdf('^x', d)

# ends with
grepdf('b$', d)

}
\seealso{
\code{\link[base]{grep}}, \code{\link{grepv}}
}
