% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpipe.R
\name{apply_right.default}
\alias{apply_right.default}
\title{S3 dispatch on type of pipe_right_argument.}
\usage{
\method{apply_right}{default}(pipe_left_arg, pipe_right_arg, pipe_environment,
  left_arg_name, pipe_string, right_arg_name)
}
\arguments{
\item{pipe_left_arg}{left argument}

\item{pipe_right_arg}{substitute(pipe_right_arg) argument}

\item{pipe_environment}{environment to evaluate in}

\item{left_arg_name}{name, if not NULL name of left argument.}

\item{pipe_string}{character, name of pipe operator.}

\item{right_arg_name}{name, if not NULL name of right argument.}
}
\value{
result
}
\description{
Triggered if right hand side was a name that does not resolve to a function.
Default implementation is re-dispatch through \code{\link{apply_left}}.
Currently this is not thought to be a common execution case.
}
\examples{

v <- list(1, 2)
f <- function(z) { format(z) }
f \%.>\% v

}
\seealso{
\code{\link{apply_left}}, \code{\link{apply_right}}
}
