% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{pairwise_fisher_test}
\alias{pairwise_fisher_test}
\title{Pairwise Fisher's exact tests}
\usage{
pairwise_fisher_test(
  dep_var,
  indep_var,
  adjmethod = "fdr",
  plevel = 0.05,
  symbols = letters[-1],
  ref = FALSE
)
}
\arguments{
\item{dep_var}{dependent variable, containing the data.}

\item{indep_var}{independent variable, should be factor or coercible.}

\item{adjmethod}{method for adjusting p values (see \link{p.adjust}).}

\item{plevel}{threshold for significance.}

\item{symbols}{predefined as b,c, d...;  provides footnotes to mark group
differences, e.g. b means different from group 2}

\item{ref}{is the 1st subgroup the reference (like in Dunnett test)?}
}
\value{
A list with elements "methods" (character), "p.value" (matrix),
"plevel" (numeric), and "sign_colwise" (vector of length number of levels - 1)
}
\description{
\code{pairwise_fisher_test} calculates pairwise comparisons between
group levels with corrections for multiple testing.
}
\examples{
# All pairwise comparisons
pairwise_fisher_test(dep_var = mtcars$cyl, indep_var = mtcars$gear)
# Only comparison against reference gear=3
pairwise_fisher_test(dep_var = mtcars$cyl, indep_var = mtcars$gear, ref = TRUE)
}
