% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkGroupOrderSEM.R
\name{checkGrpOrderSEM}
\alias{checkGrpOrderSEM}
\title{Check order of multiple groups including non-overlapping SEM-margins}
\usage{
checkGrpOrderSEM(
  x,
  grp,
  sdFact = 1,
  revRank = TRUE,
  shrink1sampSd = TRUE,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{matrix or data.frame}

\item{grp}{(factor) to organize replicate columns of (x)}

\item{sdFact}{(numeric) is proportional factor how many units of SEM will be used for defining lower & upper bounds of each group}

\item{revRank}{(logical) optionally revert ranks}

\item{shrink1sampSd}{(logical)}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
logical vector if order correct (as expected based on ranks)
}
\description{
\code{checkGrpOrderSEM} tests each line of 'x' if expected order of (replicate-) groups (defined in 'grp') appears intact,
 while inluding SEM of groups (replicates) via a proportional weight 'sdFact' as (avGr1-gr1SEM) < (avGr1+gr1SEM) < (avGr2-gr2SEM) < (avGr2+gr2SEM).  
Used for comparing groups of measures with expected profile (by matching expected order)
to check if data in 'x' represting groups ('grp') as lines follow.  
Groups of size=1: The sd (and SEM) can't be estimated directly without any replicates, however, an estimate can be given by shrinking if 'shrink1sampSd'=TRUE 
under the hypothesis that the overall mechanisms determining the variances is constant across all samples.
}
\examples{
mat1 <- matrix(rep(11:24,3)[1:40],byrow=TRUE,ncol=8)
checkGrpOrderSEM(mat1,grp=gl(3,3)[-1])
}
\seealso{
takes only 10% more time than \code{\link[wrMisc]{checkGrpOrder}} wo considering intra-group sd
}
