% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimmedMean.R
\name{trimmedMean}
\alias{trimmedMean}
\title{Trimmed Mean}
\usage{
trimmedMean(
  dat,
  trim = c(l = 0.2, u = 0.2),
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{(numeric) numeric vector}

\item{trim}{(numeric, length=2) specifies how data should get trimmed, lower and upper fraction(s) to exclude have to be assigned separately.
The lower and upper fraction may be named 'l' and 'u'.
The value 0 means that all (sorted) data on a given side will be used.}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This function returns a (numeric) vector with the trimmed mean
}
\description{
This function allows more flexible options for calculating a trimmed mean compared to \code{mean} (from the base-package).
For example, the trimming may be asymmetric to the median of the data.
}
\details{
If the second value of trim is <0.5 it is supposed that this indicates a fraction from the upper end the vector-dat as \code{\link[base]{mean}} does.
Otherwise, \code{trim=c(l=0.2,u=0.7)} will be interpreted indication to use the 20th percentile to 70th percentile of \code{dat}.

Please note, that trimmed means - and in particular asymmetric trimmed means - should be used with caution as there is also a risk of introducing bias.
}
\examples{
x <- c(17:11,27:28)
mean(x); mean(x, trim=0.15)
trimmedMean(x, trim=c(l=0, u=0.7))   # asymmetric trim

}
\seealso{
\code{\link[base]{mean}} (symmetric trimming only)
}
