% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nFragments.R
\name{nFragments}
\alias{nFragments}
\title{Number of fragments after cut at specific character(s) within size-range}
\usage{
nFragments(protSeq, cutAt, sizeRa)
}
\arguments{
\item{protSeq}{(character)  text to be cut}

\item{cutAt}{(character) position to cut}

\item{sizeRa}{(numeric,length=2) min and max size to consider}
}
\value{
numeric vector with number of fragments for each entry 'protSeq' (names are 'protSeq')
}
\description{
\code{nFragments} determines number of fragments /entry within range of 'sizeRa' (numeric,length=2) when cutting after 'cutAt'
}
\examples{
tmp <- "MSVSREDSCELDLVYVTERIIAVSFPSTANEENFRSNLREVAQMLKSKHGGNYLLFNLSERRPDITKLHAKVLEFGWPDLHTPALEKI"
nFragments(c(tmp,"ojioRij"),c("R","K"),c(4,31))

}
\seealso{
\code{\link{cutAtMultSites}}, simple version \code{{nFragments0}} (no size-range)
}
