% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regrBy1or2point.R
\name{regrBy1or2point}
\alias{regrBy1or2point}
\title{Rescaling according to reference data using linear regression.}
\usage{
regrBy1or2point(inDat, refLst, regrTo = c(1, 0.5), silent = FALSE,
  callFrom = NULL)
}
\arguments{
\item{inDat}{matrix or data.frame}

\item{refLst}{list of names existing in inDat (one group of names for each value in 'regrTo'), to be transformed in values precised in 'regTo'; if no matches to names of 'inDat' found, the 2 lowest and/or highest highest values will be chosen}

\item{regrTo}{(numeric,length=2) range (at scale 0-1) of target-values for mean of elements cited in 'refLst'}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of message(s) produced}
}
\value{
normalized matrix
}
\description{
\code{regrBy1or2point} does rescaling: linear transform simple vector 'inDat' that (mean of) elements of names cited in 'refLst' will end up as values 'regrTo'. 
Regress single vector according to 'refLst' (describing names of inDat).
If 'refLst' contains 2 groups, the 1st group will be set to the 1st value of 'regrTo' (and the 2nd group of 'refLst' to the 2nd 'regtTo')
}
\examples{
set.seed(2016); dat1 <- 1:50 +(1:50)*round(runif(50),1)
names(dat1) <- 1:length(dat1)
reg1 <- regrBy1or2point(dat1,refLst=c("2","49"))
plot(reg1,dat1) 
}
\seealso{
\code{\link{adjBy2ptReg}}, \code{\link{regrMultBy1or2point}}
}
