% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broom.R
\name{glance.workflow}
\alias{glance.workflow}
\title{Glance at a workflow model}
\usage{
\method{glance}{workflow}(x, ...)
}
\arguments{
\item{x}{A workflow}

\item{...}{Arguments passed on to methods}
}
\description{
This is a \code{\link[generics:glance]{generics::glance()}} method for a workflow that calls \code{glance()} on
the underlying parsnip model.

\code{x} must be a trained workflow, resulting in fitted parsnip model to
\code{glance()} at.
}
\examples{
if (rlang::is_installed("broom")) {

library(parsnip)
library(magrittr)
library(modeldata)

data("attrition")

model <- logistic_reg() \%>\%
  set_engine("glm")

wf <- workflow() \%>\%
  add_model(model) \%>\%
  add_formula(
    Attrition ~ BusinessTravel + YearsSinceLastPromotion + OverTime
  )

# Workflow must be trained to call `glance()`
try(glance(wf))

wf_fit <- fit(wf, attrition)

glance(wf_fit)

}
}
