% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git.R
\name{extract_commit}
\alias{extract_commit}
\title{Extract a commit from a Git repository}
\usage{
extract_commit(path, num)
}
\arguments{
\item{path}{character. Specify the path to a directory that is a Git
repository (or any subdirectory of the Git repository).}

\item{num}{numeric. The number of the commit to extract in reverse
chronological order. In other words, 1 is the most recent commit, 2 is the
second most recent commit, etc.}
}
\value{
A list with the named elements \code{sha1} and \code{message} (both
  characters). If a Git repository is not found at \code{path}, both are
  \code{NA}.
}
\description{
\code{extract_commit} extracts the 7-digit SHA1 identifier and message for a
specified commit.
}
\examples{
\dontrun{
# Most recent commit
extract_commit(".", 1)
# Penultimate commit
extract_commit(".", 2)
}
}
\keyword{internal}
