% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worcs_badge.R
\name{worcs_badge}
\alias{worcs_badge}
\title{Add WORCS badge to README.md}
\usage{
worcs_badge(
  path = ".",
  update_readme = "README.md",
  update_csv = "checklist.csv"
)
}
\arguments{
\item{path}{Character. This can either be the path to a WORCS project folder
(a project with a \code{.worcs} file), or the path to a \code{checklist.csv}
file. The latter is useful if you want to evaluate a manually updated
checklist file. Default: '.' (path to current directory).}

\item{update_readme}{Character. Path to the \code{README.md} file to add the
badge to. Default: 'README.md'. Set to \code{NULL} to avoid updating the
\code{README.md} file.}

\item{update_csv}{Character. Path to the \code{README.md} file to add the
badge to. Default: 'checklist.csv'. Set to \code{NULL} to avoid updating the
\code{checklist.csv} file.}
}
\value{
No return value. This function is called for its side effects.
}
\description{
Evaluates whether a project meets the criteria of the WORCS
checklist (see \code{\link{worcs_checklist}}), and adds a badge to the
project's \code{README.md}.
}
\examples{
example_dir <- file.path(tempdir(), "badge")
dir.create(example_dir)
write("a", file.path(example_dir, ".worcs"))
worcs_badge(path = example_dir,
update_readme = NULL)
}
