% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_woe.R
\name{apply_woe}
\alias{apply_woe}
\title{Weight of Evidence based segmentation of a variable}
\usage{
apply_woe(df, woe_object)
}
\arguments{
\item{df}{A data frame. The variable names and types need to be identical to the ones passed to woe_binning}

\item{woe_object}{Output object from woe_binning function}
}
\value{
Input data frame is returned with two new columns - bin & woe
}
\description{
This function applies the binning generated from woe_binning to new data
}
\examples{
library(smbinning)
data("chileancredit")
\dontrun{woe_object <- woe_binning(chileancredit, "cbs1", "fgood", initial_bins = 10)
out <- apply_woe(chileancredit, woe_object)
#Run Above 2 lines to create and apply woe segmentation }

}
