% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_legendre.R
\name{.CalcLegendreComponents}
\alias{.CalcLegendreComponents}
\title{Compute Legendre Components}
\usage{
.CalcLegendreComponents(n, m)
}
\arguments{
\item{n}{degree of associated Legendre function}

\item{m}{order of associated Legendre function}
}
\description{
Function that computes the components of the associated Legendre function, \eqn{P_{n,m}(\mu)}{P(mu, n, m)}, only dependent on (degree, order) indices. This function is only used to precompute values.
}
\details{
The underlying equation used is: \deqn{P(x, n, m)=(-1)^m * 2^n * (1-x^2)^(m/2) * sum(for m <= k <= n: k!/(k-m)! * x^(k-m) * choose(n, k) * choose((n+k-1)/2, n))}
}
