context("  Row NAs")

test_that("row_nas for integer matrices works.", {
    expected <- apply(int_na_mat, 1L, function(x) { all(is.na(x)) })
    ans <- row_nas(int_na_mat, "all")
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "all", output_class = "list")
    expect_identical(ans, as.list(expected))

    expected <- apply(int_na_mat, 1L, function(x) { all(!is.na(x)) })
    ans <- row_nas(int_na_mat, "none")
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "none", output_class = "list")
    expect_identical(ans, as.list(expected))

    expected <- apply(int_na_mat, 1L, function(x) { anyNA(x) })
    ans <- row_nas(int_na_mat, "any")
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "any", output_class = "list")
    expect_identical(ans, as.list(expected))
})

test_that("row_nas for integer matrices with column subset works.", {
    expected <- apply(int_na_mat[, -2L], 1L, function(x) { all(is.na(x)) })
    ans <- row_nas(int_na_mat, "all", cols = c(1, 3))
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "all", cols = -2L)
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "all", cols = c(TRUE, FALSE, TRUE))
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "all", cols = -2.0, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(int_na_mat, "all", cols = integer())
    expect_true(all(!ans))

    expected <- apply(int_na_mat[, -2L], 1L, function(x) { all(!is.na(x)) })
    ans <- row_nas(int_na_mat, "none", cols = c(1, 3))
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "none", cols = -2L)
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "none", cols = c(TRUE, FALSE, TRUE))
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "none", cols = -2.0, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(int_na_mat, "none", cols = integer())
    expect_true(all(ans))

    expected <- apply(int_na_mat[, -2L], 1L, function(x) { anyNA(x) })
    ans <- row_nas(int_na_mat, "any", cols = c(1, 3))
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "any", cols = -2L)
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "any", cols = c(TRUE, FALSE, TRUE))
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "any", cols = -2.0, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(int_na_mat, "any", cols = integer())
    expect_true(all(!ans))
})

test_that("row_nas for integer matrices with row subset works.", {
    expected <- apply(int_na_mat[1001:2000,], 1L, function(x) { all(is.na(x)) })
    ans <- row_nas(int_na_mat, "all", rows = 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "all", rows = 1:5000 %in% 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "all", rows = -c(1:1000, 2001:5000))
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "all", rows = 1001:2000, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(int_na_mat, "all", rows = integer())
    expect_identical(ans, logical())

    expected <- apply(int_na_mat[1001:2000,], 1L, function(x) { all(!is.na(x)) })
    ans <- row_nas(int_na_mat, "none", rows = 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "none", rows = 1:5000 %in% 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "none", rows = -c(1:1000, 2001:5000))
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "none", rows = 1001:2000, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(int_na_mat, "none", rows = integer())
    expect_identical(ans, logical())

    expected <- apply(int_na_mat[1001:2000,], 1L, function(x) { anyNA(x) })
    ans <- row_nas(int_na_mat, "any", rows = 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "any", rows = 1:5000 %in% 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "any", rows = -c(1:1000, 2001:5000))
    expect_identical(ans, expected)
    ans <- row_nas(int_na_mat, "any", rows = 1001:2000, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(int_na_mat, "any", rows = integer())
    expect_identical(ans, logical())
})

test_that("row_nas for double matrices works.", {
    expected <- apply(dbl_na_mat, 1L, function(x) { all(is.na(x)) })
    ans <- row_nas(dbl_na_mat, "all")
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "all", output_class = "list")
    expect_identical(ans, as.list(expected))

    expected <- apply(dbl_na_mat, 1L, function(x) { all(!is.na(x)) })
    ans <- row_nas(dbl_na_mat, "none")
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "none", output_class = "list")
    expect_identical(ans, as.list(expected))

    expected <- apply(dbl_na_mat, 1L, function(x) { anyNA(x) })
    ans <- row_nas(dbl_na_mat, "any")
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "any", output_class = "list")
    expect_identical(ans, as.list(expected))
})

test_that("row_nas for double matrices with column subset works.", {
    expected <- apply(dbl_na_mat[, -2L], 1L, function(x) { all(is.na(x)) })
    ans <- row_nas(dbl_na_mat, "all", cols = c(1, 3))
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "all", cols = -2L)
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "all", cols = c(TRUE, FALSE, TRUE))
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "all", cols = -2.0, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(dbl_na_mat, "all", cols = integer())
    expect_true(all(!ans))

    expected <- apply(dbl_na_mat[, -2L], 1L, function(x) { all(!is.na(x)) })
    ans <- row_nas(dbl_na_mat, "none", cols = c(1, 3))
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "none", cols = -2L)
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "none", cols = c(TRUE, FALSE, TRUE))
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "none", cols = -2.0, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(dbl_na_mat, "none", cols = integer())
    expect_true(all(ans))

    expected <- apply(dbl_na_mat[, -2L], 1L, function(x) { anyNA(x) })
    ans <- row_nas(dbl_na_mat, "any", cols = c(1, 3))
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "any", cols = -2L)
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "any", cols = c(TRUE, FALSE, TRUE))
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "any", cols = -2.0, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(dbl_na_mat, "any", cols = integer())
    expect_true(all(!ans))
})

test_that("row_nas for double matrices with row subset works.", {
    expected <- apply(dbl_na_mat[1001:2000,], 1L, function(x) { all(is.na(x)) })
    ans <- row_nas(dbl_na_mat, "all", rows = 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "all", rows = 1:5000 %in% 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "all", rows = -c(1:1000, 2001:5000))
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "all", rows = 1001:2000, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(dbl_na_mat, "all", rows = integer())
    expect_identical(ans, logical())

    expected <- apply(dbl_na_mat[1001:2000,], 1L, function(x) { all(!is.na(x)) })
    ans <- row_nas(dbl_na_mat, "none", rows = 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "none", rows = 1:5000 %in% 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "none", rows = -c(1:1000, 2001:5000))
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "none", rows = 1001:2000, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(dbl_na_mat, "none", rows = integer())
    expect_identical(ans, logical())

    expected <- apply(dbl_na_mat[1001:2000,], 1L, function(x) { anyNA(x) })
    ans <- row_nas(dbl_na_mat, "any", rows = 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "any", rows = 1:5000 %in% 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "any", rows = -c(1:1000, 2001:5000))
    expect_identical(ans, expected)
    ans <- row_nas(dbl_na_mat, "any", rows = 1001:2000, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(dbl_na_mat, "any", rows = integer())
    expect_identical(ans, logical())
})

test_that("row_nas for logical matrices works.", {
    expected <- apply(bool_na_mat, 1L, function(x) { all(is.na(x)) })
    ans <- row_nas(bool_na_mat, "all")
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "all", output_class = "list")
    expect_identical(ans, as.list(expected))

    expected <- apply(bool_na_mat, 1L, function(x) { all(!is.na(x)) })
    ans <- row_nas(bool_na_mat, "none")
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "none", output_class = "list")
    expect_identical(ans, as.list(expected))

    expected <- apply(bool_na_mat, 1L, function(x) { anyNA(x) })
    ans <- row_nas(bool_na_mat, "any")
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "any", output_class = "list")
    expect_identical(ans, as.list(expected))
})

test_that("row_nas for logical matrices with column subset works.", {
    expected <- apply(bool_na_mat[, -2L], 1L, function(x) { all(is.na(x)) })
    ans <- row_nas(bool_na_mat, "all", cols = c(1, 3))
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "all", cols = -2L)
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "all", cols = c(TRUE, FALSE, TRUE))
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "all", cols = -2.0, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(bool_na_mat, "all", cols = integer())
    expect_true(all(!ans))

    expected <- apply(bool_na_mat[, -2L], 1L, function(x) { all(!is.na(x)) })
    ans <- row_nas(bool_na_mat, "none", cols = c(1, 3))
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "none", cols = -2L)
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "none", cols = c(TRUE, FALSE, TRUE))
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "none", cols = -2.0, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(bool_na_mat, "none", cols = integer())
    expect_true(all(ans))

    expected <- apply(bool_na_mat[, -2L], 1L, function(x) { anyNA(x) })
    ans <- row_nas(bool_na_mat, "any", cols = c(1, 3))
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "any", cols = -2L)
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "any", cols = c(TRUE, FALSE, TRUE))
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "any", cols = -2.0, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(bool_na_mat, "any", cols = integer())
    expect_true(all(!ans))
})

test_that("row_nas for logical matrices with row subset works.", {
    expected <- apply(bool_na_mat[1001:2000,], 1L, function(x) { all(is.na(x)) })
    ans <- row_nas(bool_na_mat, "all", rows = 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "all", rows = 1:5000 %in% 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "all", rows = -c(1:1000, 2001:5000))
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "all", rows = 1001:2000, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(bool_na_mat, "all", rows = integer())
    expect_identical(ans, logical())

    expected <- apply(bool_na_mat[1001:2000,], 1L, function(x) { all(!is.na(x)) })
    ans <- row_nas(bool_na_mat, "none", rows = 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "none", rows = 1:5000 %in% 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "none", rows = -c(1:1000, 2001:5000))
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "none", rows = 1001:2000, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(bool_na_mat, "none", rows = integer())
    expect_identical(ans, logical())

    expected <- apply(bool_na_mat[1001:2000,], 1L, function(x) { anyNA(x) })
    ans <- row_nas(bool_na_mat, "any", rows = 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "any", rows = 1:5000 %in% 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "any", rows = -c(1:1000, 2001:5000))
    expect_identical(ans, expected)
    ans <- row_nas(bool_na_mat, "any", rows = 1001:2000, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(bool_na_mat, "any", rows = integer())
    expect_identical(ans, logical())
})

test_that("row_nas for complex matrices works.", {
    expected <- apply(cplx_na_mat, 1L, function(x) { all(is.na(x)) })
    ans <- row_nas(cplx_na_mat, "all")
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "all", output_class = "list")
    expect_identical(ans, as.list(expected))

    expected <- apply(cplx_na_mat, 1L, function(x) { all(!is.na(x)) })
    ans <- row_nas(cplx_na_mat, "none")
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "none", output_class = "list")
    expect_identical(ans, as.list(expected))

    expected <- apply(cplx_na_mat, 1L, function(x) { anyNA(x) })
    ans <- row_nas(cplx_na_mat, "any")
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "any", output_class = "list")
    expect_identical(ans, as.list(expected))
})

test_that("row_nas for complex matrices with column subset works.", {
    expected <- apply(cplx_na_mat[, -2L], 1L, function(x) { all(is.na(x)) })
    ans <- row_nas(cplx_na_mat, "all", cols = c(1, 3))
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "all", cols = -2L)
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "all", cols = c(TRUE, FALSE, TRUE))
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "all", cols = -2.0, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(cplx_na_mat, "all", cols = integer())
    expect_true(all(!ans))

    expected <- apply(cplx_na_mat[, -2L], 1L, function(x) { all(!is.na(x)) })
    ans <- row_nas(cplx_na_mat, "none", cols = c(1, 3))
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "none", cols = -2L)
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "none", cols = c(TRUE, FALSE, TRUE))
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "none", cols = -2.0, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(cplx_na_mat, "none", cols = integer())
    expect_true(all(ans))

    expected <- apply(cplx_na_mat[, -2L], 1L, function(x) { anyNA(x) })
    ans <- row_nas(cplx_na_mat, "any", cols = c(1, 3))
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "any", cols = -2L)
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "any", cols = c(TRUE, FALSE, TRUE))
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "any", cols = -2.0, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(cplx_na_mat, "any", cols = integer())
    expect_true(all(!ans))
})

test_that("row_nas for complex matrices with row subset works.", {
    expected <- apply(cplx_na_mat[1001:2000,], 1L, function(x) { all(is.na(x)) })
    ans <- row_nas(cplx_na_mat, "all", rows = 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "all", rows = 1:5000 %in% 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "all", rows = -c(1:1000, 2001:5000))
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "all", rows = 1001:2000, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(cplx_na_mat, "all", rows = integer())
    expect_identical(ans, logical())

    expected <- apply(cplx_na_mat[1001:2000,], 1L, function(x) { all(!is.na(x)) })
    ans <- row_nas(cplx_na_mat, "none", rows = 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "none", rows = 1:5000 %in% 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "none", rows = -c(1:1000, 2001:5000))
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "none", rows = 1001:2000, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(cplx_na_mat, "none", rows = integer())
    expect_identical(ans, logical())

    expected <- apply(cplx_na_mat[1001:2000,], 1L, function(x) { anyNA(x) })
    ans <- row_nas(cplx_na_mat, "any", rows = 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "any", rows = 1:5000 %in% 1001:2000)
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "any", rows = -c(1:1000, 2001:5000))
    expect_identical(ans, expected)
    ans <- row_nas(cplx_na_mat, "any", rows = 1001:2000, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(cplx_na_mat, "any", rows = integer())
    expect_identical(ans, logical())
})

test_that("row_nas for data frames works.", {
    expected <- sapply(3001:5000, df = df, function(i, df) { all(is.na(df[i, , drop = FALSE])) })
    ans <- row_nas(df, "all", rows = 3001:5000)
    expect_identical(ans, expected)
    ans <- row_nas(df, "all", rows = 3001:5000, output_class = "list")
    expect_identical(ans, as.list(expected))

    expected <- sapply(3001:5000, df = df, function(i, df) { all(!is.na(df[i, , drop = FALSE])) })
    ans <- row_nas(df, "none", rows = 3001:5000)
    expect_identical(ans, expected)
    ans <- row_nas(df, "none", rows = 3001:5000, output_class = "list")
    expect_identical(ans, as.list(expected))

    expected <- sapply(3001:5000, df = df, function(i, df) { anyNA(df[i, , drop = FALSE]) })
    ans <- row_nas(df, "any", rows = 3001:5000)
    expect_identical(ans, expected)
    ans <- row_nas(df, "any", rows = 3001:5000, output_class = "list")
    expect_identical(ans, as.list(expected))
})

test_that("row_nas behaves like in R for infinite/NaN values.", {
    df <- data.frame(Inf, -Inf, as.complex(Inf), as.complex(-Inf))
    expect_true(row_nas(df, "none"))
    expect_true(row_nas(data.frame(NaN), "any"))
})

test_that("row_nas for factor columns works.", {
    df <- as.data.frame(lapply(df[, paste0("char.V", 1:3)], as.factor))

    expected <- sapply(3001:5000, df = df, function(i, df) { all(is.na(df[i, , drop = FALSE])) })
    ans <- row_nas(df, "all", rows = 3001:5000)
    expect_identical(ans, expected)
    ans <- row_nas(df, "all", rows = 3001:5000, output_class = "list", factor_mode = "int")
    expect_identical(ans, as.list(expected))

    expected <- sapply(3001:5000, df = df, function(i, df) { all(!is.na(df[i, , drop = FALSE])) })
    ans <- row_nas(df, "none", rows = 3001:5000)
    expect_identical(ans, expected)
    ans <- row_nas(df, "none", rows = 3001:5000, output_class = "list", factor_mode = "int")
    expect_identical(ans, as.list(expected))

    expected <- sapply(3001:5000, df = df, function(i, df) { anyNA(df[i, , drop = FALSE]) })
    ans <- row_nas(df, "any", rows = 3001:5000)
    expect_identical(ans, expected)
    ans <- row_nas(df, "any", rows = 3001:5000, output_class = "list", factor_mode = "int")
    expect_identical(ans, as.list(expected))
})

test_that("which_first in row_nas works.", {
    expected <- sapply(3001:5000, df = df, function(i, df) { Position(is.na, df[i, , drop = FALSE]) })
    ans <- row_nas(df, "which_first", rows = 3001:5000)
    expect_identical(ans, expected)

    expected <- lapply(3001:5000, df = df, function(i, df) { Position(is.na, df[i, -1L, drop = FALSE]) })
    ans <- row_nas(df, "which_first", rows = 3001:5000, cols = -1L, output_class = "list")
    expect_identical(ans, expected)
})

test_that("row_nas supports different output classes.", {
    expected <- sapply(3001:5000, df = df, function(i, df) { all(is.na(df[i, , drop = FALSE])) })

    ans <- row_nas(df, "all", rows = 3001:5000)
    expect_identical(ans, expected)

    ans <- row_nas(df, "all", rows = 3001:5000, output_class = "list")
    expect_identical(ans, as.list(expected))

    ans <- row_nas(df, "all", rows = 3001:5000, output_class = "data.frame")
    expect_identical(ans, data.frame(V1 = expected))

    ans <- row_nas(df, "all", rows = 3001:5000, output_class = "matrix")
    expect_identical(ans, as.matrix(expected))
})

test_that("row_nas for match_type='count' works.", {
    expected <- apply(int_na_mat, 1L, function(row) { sum(is.na(row)) })
    ans <- row_nas(int_na_mat, "count")
    expect_identical(ans, expected)

    expected <- sapply(3001:5000, df = df, function(i, df) { sum(is.na(df[i, , drop = FALSE])) })
    ans <- row_nas(df, "count", rows = 3001:5000)
    expect_identical(ans, expected)
})
