% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwtr.R
\name{RWTR}
\alias{RWTR}
\title{Restricted win time ratio}
\usage{
RWTR(n, m, tau, tg, Time, Delta)
}
\arguments{
\item{n}{The total number of trial participants.}

\item{m}{The number of events in the hierarchy.}

\item{tau}{The maximum follow up time (days).}

\item{tg}{A numeric vector containing treatment arm indicators (1 for treatment, 0 for control).}

\item{Time}{A m x n matrix of event times (days), where m is the number of events in the hierarchy, and n is the total number of trial participants.
Rows should represent events and columns should represent participants. Event rows should be in increasing order of clinical severity.}

\item{Delta}{A m x n matrix of event indicators, where m is the number of events in the hierarchy, and n is the total number of trial participants.
Rows should represent events and columns should represent participants. Event rows should be in increasing order of clinical severity.}
}
\value{
A list containing: The ratio of losses to wins on treatment, the total number of wins, and the total number of losses.
}
\description{
This function calculates the ratio of losses to wins on treatment. It iterates through all pairs of treatment and control patients and uses
their time-to-death (or most severe clinical event) to determine a win or loss. If death is inconclusive, then a winner is determined based
on wintime.
}
