% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_grids.R
\name{get_grids}
\alias{get_grids}
\title{Get the Grid-IDs from binary matrix}
\usage{
get_grids(trimtonOut, Grid)
}
\arguments{
\item{trimtonOut}{Input matrix with binary values.}

\item{Grid}{Grid of the considered area}
}
\value{
Returns a list of all individuals with X and Y coordinates and the
  grid cell ID.
}
\description{
Get the grid IDs from the trimmed binary matrix, where the
  binary code indicates which grid cells are used in the current wind farm
  constellation.
}
\examples{
\donttest{
## Create a random rectangular shapefile
library(sp)
Polygon1 <- Polygon(rbind(c(0, 0), c(0, 2000), c(2000, 2000), c(2000, 0)))
Polygon1 <- Polygons(list(Polygon1),1);
Polygon1 <- SpatialPolygons(list(Polygon1))
Projection <- "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000
+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
proj4string(Polygon1) <- CRS(Projection)

## Calculate a Grid and an indexed data.frame with coordinates and grid cell Ids.
Grid1 <- grid_area(shape = Polygon1,resol = 200,prop = 1);
Grid <- Grid1[[1]]
AmountGrids <- nrow(Grid)

startsel <- init_population(Grid,10,20);
wind <- data.frame(ws = 12, wd = 0)
wind <- list(wind, probab = 100)
fit <- fitness(selection = startsel,referenceHeight = 100, RotorHeight=100,
               SurfaceRoughness=0.3,Polygon = Polygon1, resol1 = 200,rot=20,
               dirspeed = wind, srtm_crop="",topograp=FALSE,cclRaster="")
allparks <- do.call("rbind",fit);

## SELECTION
## print the amount of Individuals selected.
## Check if the amount of Turbines is as requested.
selec6best <- selection(fit, Grid,2, TRUE, 6, "VAR");

## CROSSOVER
## u determines the amount of crossover points,
## crossPart determines the method used (Equal/Random),
## uplimit is the maximum allowed permutations
crossOut <- crossover(selec6best, 2, uplimit = 300, crossPart="RAN");

## MUTATION
## Variable Mutation Rate is activated if more than 2 individuals represent the
## current best solution.
mut <- mutation(a = crossOut, p = 0.3);

## TRIMTON
## After Crossover and Mutation, the amount of turbines in a windpark change
## and have to be corrected to the required amount of turbines.
mut1 <- trimton(mut = mut, nturb = 10, allparks = allparks,
               nGrids = AmountGrids, trimForce=FALSE)

## Get the new Grid-Ids and run a new fitness run.
getRectV <- get_grids(mut1, Grid)
fit <- fitness(selection = getRectV,referenceHeight = 100, RotorHeight=100,
               SurfaceRoughness=0.3,Polygon = Polygon1, resol1 = 200,rot=20,
               dirspeed = wind, srtm_crop="",topograp=FALSE,cclRaster="")
head(fit)

}
}
\seealso{
Other Helper Functions: \code{\link{dup_coords}},
  \code{\link{getDEM}}, \code{\link{getISO3}},
  \code{\link{grid_area}}, \code{\link{hexa_area}},
  \code{\link{isSpatial}}, \code{\link{permutations}},
  \code{\link{readintegerSel}}, \code{\link{readinteger}},
  \code{\link{splitAt}}, \code{\link{tess2SPdf}},
  \code{\link{windata_format}}
}
\concept{Helper Functions}
