% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotcloud.R
\name{plotCloud}
\alias{plotCloud}
\title{Plot outputs of all generations with standard deviations}
\usage{
plotCloud(result, pl = FALSE)
}
\arguments{
\item{result}{The output matrix of \code{\link{windfarmGA}} or
\code{\link{genAlgo}}, which has stored all relevant information.}

\item{pl}{Should the results be plotted? Default is FALSE}
}
\value{
Returns a data.frame with the values for fitness, efficiency
and energy for all evaluated individuals.
}
\description{
Plot all the fitness, efficiency and energy outputs of
all generations. Plot the corresponding standard deviation below.
}
\examples{
\donttest{
## Add some data examples from the package
load(file = system.file("extdata/resulthex.rda", package = "windfarmGA"))

## Plot the results of a hexagonal grid optimization
result <- resulthex
plcdf <- plotCloud(result, TRUE)
str(plcdf)
}
}
\author{
Sebastian Gatscha
}
