% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{create_geneview}
\alias{create_geneview}
\title{Method for geneView creation}
\usage{
create_geneview(
  data,
  grouping,
  plot.type = "line",
  facet.target = "gene",
  facet.cols = 2,
  colors = NULL,
  ylabel = NULL,
  ylimits = NULL,
  gene.label = NULL,
  plot.method = "static",
  width = "auto",
  height = "auto",
  ppi = 72,
  scale = 1
)
}
\arguments{
\item{data}{data.table containing plot data}

\item{grouping}{data.table metadata containing:
column1 : key
column2 : factor1}

\item{plot.type}{String specifying which plot type is used c("box", "line", "violin", "bar").}

\item{facet.target}{Target to plot on x-Axis c("gene", "condition").}

\item{facet.cols}{Number of plots per row.}

\item{colors}{Vector of colors used for color palette}

\item{ylabel}{Label of the y-axis (default = NULL).}

\item{ylimits}{Vector defining scale of y-axis (default = NULL).}

\item{gene.label}{Vector of labels used instead of gene names (default = NULL).}

\item{plot.method}{Choose which method used for plotting. Either "static" or "interactive" (Default = "static").}

\item{width}{Set the width of the plot in cm (default = "auto").}

\item{height}{Set the height of the plot in cm (default = "auto").}

\item{ppi}{Pixel per inch (default = 72).}

\item{scale}{Modify plot size while preserving aspect ratio (Default = 1).}
}
\value{
Returns depending on plot.method list(plot = ggplot/ plotly object, width = width in cm, height = height in cm, ppi = pixel per inch, exceed_size = Boolean).
}
\description{
Method for geneView creation
}
\details{
Width/ height limit = 500. If exceeded default to 500 and issue exceed_size = TRUE.
}
