% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/and.R
\name{and}
\alias{and}
\title{AND module server logic}
\usage{
and(
  input,
  output,
  session,
  data,
  show.elements = NULL,
  element.grouping = NULL,
  column.labels = NULL,
  delimiter = NULL,
  multiple = TRUE,
  contains = FALSE,
  ranged = FALSE,
  step = 100,
  reset = NULL
)
}
\arguments{
\item{input}{Shiny's input object.}

\item{output}{Shiny's output object.}

\item{session}{Shiny's session object.}

\item{data}{The input data.frame for which selection should be provided. Evaluates an OR module for each column (Supports reactive).}

\item{show.elements}{A Vector of column names determining which OR modules are shown. Defaults to names(data). (Supports reactive)}

\item{element.grouping}{Group features in boxes. (Data.table: first column = columnnames, second column = groupnames) (Supports reactive)}

\item{column.labels}{Additional labels for the columns, defaults to \code{names(data)}.}

\item{delimiter}{A single character, or a vector indicating how column values are delimited. (Fills vector sequentially if needed)(Supports reactive)}

\item{multiple}{Whether or not textual ORs should allow multiple selections. (Fills vector sequentially if needed)(Supports reactive)}

\item{contains}{Whether or not textual ORs are initialized as textInput checking entries for given string. (Fills vector sequentially if needed)(Supports reactive)}

\item{ranged}{Whether or not numeric ORs are ranged. (Fills vector sequentially if needed)(Supports reactive)}

\item{step}{Set numeric ORs slider steps. (Fills vector sequentially if needed)(Supports reactive)}

\item{reset}{Reactive which will cause a UI reset on change.}
}
\value{
A reactive containing named list with a boolean vector of length \code{nrow(data)} (bool), indicating whether an observation is selected or not and a vector of Strings showing the used filter (text).
}
\description{
This function evaluates output from multiple OR modules by combining with a logical and.
}
