% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcPlot.R
\name{dcPlot}
\alias{dcPlot}
\title{Contact distance plot}
\usage{
dcPlot(traj, traj2, tc = 0, histplot = TRUE, dmax)
}
\arguments{
\item{traj}{an object of the class \code{move2} which contains the time-stamped movement fixes of at least two individuals. For more information on objects of this type see \code{help(mt_as_move2)}.}

\item{traj2}{(optional) same as traj, but for the second group of individuals. See \code{checkTO}.}

\item{tc}{time threshold for determining simultaneous fixes -- see function: \code{GetSimultaneous}.}

\item{histplot}{(logical) whether to output a histogram, along with a list of the natural breaks in the histogram (\code{histplot = TRUE}) or the dataframe of all paired distances used to construct the histogram (\code{histplot=FALSE}) to be used for further analysis.}

\item{dmax}{(optional) distance value to 'cut-off' the distance histogram.}
}
\value{
If \code{histplot = TRUE} a list of the natural breaks (local minima) identified from the frequency histogram and a plot of the frequency histogram.
If \code{histplot = FALSE} a dataframe containing all the pairwise and simultaneous distances between all individuals in the trajectory dataset.
}
\description{
This function is an exploratory tool to examine the pairwise distances between individuals within a large telemetry dataset.
}
\details{
The dcPlot function can be used to study the frequency distribution of pairwise distances between individual in a large telemetry dataset. It can be applied to a single group (if \code{mtraj2} is ignored) or two-groups of individuals. The code attempts to find natural breaks (local minima) in the frequency histogram using an approach based on the \code{peaks} function attributed to B. Ripley (see \url{https://stackoverflow.com/questions/6324354/add-a-curve-that-fits-the-peaks-from-a-plot-in-r} ). This tool is meant to be used for exploratory data analysis.
}
\examples{

\dontrun{
data(does)
dcPlot(does,tc=15*60,dmax=1000)
}

}
\seealso{
GetSimultaneous, conProcess, Prox, Don, IAB
}
