% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IAB.R
\name{IAB}
\alias{IAB}
\title{Benhamou's IAB Index}
\usage{
IAB(traj, traj2, tc = 0, dc = 0, local = FALSE, rand = 99)
}
\arguments{
\item{traj}{an object of the class \code{move2} which contains the time-stamped movement fixes of at least two individuals. For more information on objects of this type see \code{help(mt_as_move2)}.}

\item{traj2}{(optional) same as traj, but for the second group of individuals. See \code{checkTO}}

\item{tc}{time threshold for determining simultaneous fixes -- see function: \code{GetSimultaneous}.}

\item{dc}{critical distance where the IAB function will show maximum slope -- see Benhamou et al. (2014) for more advice on selecting this parameter.}

\item{local}{logical value indicating whether a dataframe (\code{local = TRUE}) containing the IAB index for each simultaneous fix should be returned (with a local permutation test), or (if \code{local = FALSE} - the default) the global index along with associated global permutation test.}

\item{rand}{number of permutations to use in the local permutation test.}
}
\value{
If \code{local=FALSE} (the default) IAB returns a dataframe with the values of the IAB index and the associated p-values for one-sided tests for attraction or avoidance. If \code{local=TRUE} IAB returns a dataframe (containing the date/times of \emph{all} simultaneous fixes (NOTE: times are associated with traj1), along with the distance between fixes at each time , and the IAB index value for each simultaneous fix. A localized p-value (.pa signifies the test for attraction and pb the test for avoidance) and z-score is computed based on \code{rand} permutations of the fixes. The row.name columns can be used to match the simultaneous fixes to the original trajectory.
}
\description{
The function \code{IAB} computes the IAB index following the methods described in the paper by 
Benhamou et al. (2014). It facilitates global analysis, with the significance testing procedure
described in the paper, but also a local level output, to explore the IAB statistic through time.
}
\details{
The function \code{IAB} can be used to test for direct interaction in wildlife telemetry data and affords a novel significance testing procedure that takes into account the serially correlated structure of telemetry data. Specifically, it computes an index analogous to the Bhattacharyya coefficient between the potential influence domains of two animals. Like the other indices, IAB is dependent on the selection of an appropriate value for \code{dc} (which is termed \eqn{\Delta}{Delta} in the article). The \code{dc} parameter here is not a threshold distance, but rather the distance at which the function shows maximum slope (see Benhamou et al. 2014). 

The significance testing procedure uses a wrapped shifting method in order to maintain the serially correlated structure of the data. At each shift, a sample value of IAB (termed MAB) is computed in order to generate a distribution of values to test against (for more information see Benhamou et al. 2014). Here a local version of this statistical testing procedure is implemented by taking \code{rand} samples of the \eqn{(n^2 - n} permutations of unpaired fixes. The p-values are computed following Benhamou et al. (2014), z-scores are calculated based on the mean and standard deviation of this hypothetical distribution.
}
\examples{
data(deer)
#tc = 7.5 minutes, dc = 50 meters
IAB(deer, tc=7.5*60, dc=50)
df <- IAB(deer, tc=7.5*60, dc=50, local=TRUE)

}
\references{
Benhamou, S., Valeix, M., Chamaille-Jammes, S., Macdonald, D., Loveridge, A.J. (2014) Movement-based analysis of interactions in African lions. \emph{Animal Behaviour}, \bold{90}: 171-180.
}
\seealso{
GetSimultaneous, DI, Prox
}
\keyword{indices}
