% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikicommons.R
\name{wt_wikicommons}
\alias{wt_wikicommons}
\alias{wt_wikicommons_parse}
\alias{wt_wikicommons_search}
\title{WikiCommons}
\usage{
wt_wikicommons(name, utf8 = TRUE, ...)

wt_wikicommons_parse(page, types = c("langlinks", "iwlinks", "externallinks",
  "common_names", "classification"), tidy = FALSE)

wt_wikicommons_search(query, limit = 10, offset = 0, utf8 = TRUE, ...)
}
\arguments{
\item{name}{(character) Wiki name - as a page title, must be length 1}

\item{utf8}{(logical) If `TRUE`, encodes most (but not all) non-ASCII
characters as UTF-8 instead of replacing them with hexadecimal escape
sequences. Default: `TRUE`}

\item{...}{curl options, passed on to [httr::GET()]}

\item{page}{([httr::response()]) Result of [wt_wiki_page()]}

\item{types}{(character) List of properties to parse}

\item{tidy}{(logical). tidy output to data.frame's if possible.
Default: `FALSE`}

\item{query}{(character) query terms}

\item{limit}{(integer) number of results to return. Default: 10}

\item{offset}{(integer) record to start at. Default: 0}
}
\value{
\code{wt_wikicommons} returns a list, with slots:
\itemize{
\item langlinks - language page links
\item externallinks - external links
\item common_names - a data.frame with \code{name} and \code{language} columns
\item classification - a data.frame with \code{rank} and \code{name} columns
}

\code{wt_wikicommons_parse} returns a list

\code{wt_wikicommons_search} returns a list with slots for \code{continue} and
\code{query}, where \code{query} holds the results, with \code{query$search} slot with
the search results
}
\description{
WikiCommons
}
\examples{
\dontrun{
# high level
wt_wikicommons(name = "Malus domestica")

# low level
pg <- wt_wiki_page("https://commons.wikimedia.org/wiki/Malus_domestica")
wt_wikicommons_parse(pg)

# search wikicommons
wt_wikicommons_search(query = "Pinus")

## use search results to dig into pages
res <- wt_wikicommons_search(query = "Pinus")
lapply(res$query$search$title[1:3], wt_wikicommons)
}
}
\references{
\url{https://www.mediawiki.org/wiki/API:Search} for help on search
}
