% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{v_AutoSuggest}
\alias{v_AutoSuggest}
\title{Suggests VIAF id from a name}
\usage{
v_AutoSuggest(author)
}
\arguments{
\item{author}{String to search. Please, see the structure of the author
string to obtain better results:
author: last name, first name[,] [([year_of_bird][-year_of_death])]}
}
\value{
A data-frame with four columns from the elements "term", "score",
"nametype" and "viafid" of the Autosuggest API response.
}
\description{
Search the name of the author from the VIAF AutoSuggest API and returns
information in JSON format of the records found. Note that only
returns a maximum of 10 records. Note that those records are not
VIAF cluster records.
A VIAF record is considered a "cluster record," which is the result of
combining records from many libraries around the world into a single record.
}
\examples{
v_AutoSuggest('Iranzo')
v_AutoSuggest('Esparza, María')
# Four rows, only two viafid:
v_AutoSuggest('Escobar, Modesto')
}
\seealso{
https://www.oclc.org/developer/api/oclc-apis/viaf/authority-cluster.en.html
}
