% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{w_Geoloc}
\alias{w_Geoloc}
\title{Get Latitude and Longitude coordinates, and Country of places}
\usage{
w_Geoloc(entity_list, langsorder = "", nlimit = 1000, debug = FALSE)
}
\arguments{
\item{entity_list}{A vector with de Wikidata entities (places).}

\item{langsorder}{Order of languages in which the information will be
returned, separated with '|'. If no information is given in the first
language, next is used. If langsorder=='', then labels or descriptions
are not returned.}

\item{nlimit}{If the number of entities exceeds this number, chunked queries
are done. This is the number of entities requested in each chunk. Please,
reduce the default value if error is raised.}

\item{debug}{For debugging purposes (default FALSE). If debug='info'
information about chunked queries is shown. If debug='query' also the query
launched is shown.}
}
\value{
A data-frame with 'entity', label, Latitude and Longitude, country
and label of the country.
}
\description{
Get Latitude and Longitude coordinates of the Wikidata entities which are
places. Also the countries they belong are returned.
}
\examples{
\dontrun{
w_Geoloc(c("Q57860", "Q90", "Q15695"), langsorder="")
w_Geoloc(c("Q57860", "Q90", "Q15695"), langsorder="se") # Note label of place for Q15695
w_Geoloc(c("Q57860", "Q90", "Q15695"), langsorder="se|fr")
df <- w_SearchByOccupation(Qoc='Q2306091') # aprox. 20000
l <- df$entity
# Get birth-place (P19)
p <- w_Property(l, Pproperty = 'P19', includeQ=TRUE, langsorder='es|en', debug='info')
# Filter entities that have places
places <- p[grepl("^Q\\\\d+$", p$P19), ]$P19
g <- w_Geoloc(places, langsorder='en|es', debug='info')
}
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
