% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_density.R
\name{fig_density}
\alias{fig_density}
\title{Plot a density of a score}
\usage{
fig_density(
  df,
  score,
  var_color = NULL,
  var_facet = NULL,
  cutoffs = NULL,
  x_lab = "Score",
  pal = "Paired",
  adjust = 2,
  size = 1.5
)
}
\arguments{
\item{df}{a data frame where each row is an individual, containing at least a score column (between 0 and 100)}

\item{score}{a string (length 1) of the column name for the score variable to print the distribution of}

\item{var_color}{a string (length 1) of the column name for the variable to set color of density lines by. Default is NULL.}

\item{var_facet}{a string (length 1) of the column name for the variable to create a \code{ggplot2::facet_grid()} with. Default is NULL.}

\item{cutoffs}{a numeric vector of the cut-offs for the score categorization. Default is NULL.}

\item{x_lab}{a string (length 1) of x-axis label. Default is "Score".}

\item{pal}{a string specifying either a manual color to use for the color aesthetic, a character vector explictly specifying the colors to use for the color scale, or as the name of a palette to pass to \code{RColorBrewer::brewer.pal()} with the name of the color palette to use for the color scale. Default is \code{"Paired"}}

\item{adjust}{a numeric value to pass to \code{adjust} argument of \code{ggplot2::geom_density()}. Default is 2.}

\item{size}{a numeric value to pass to \code{size} argument of \code{ggplot2::geom_density()}. Default is 1.5.}
}
\value{
A density figure
}
\description{
Plot a density of a score
}
\details{
Plots a histogram of a score that ranges between 0 and 100, with the fill determined by some set categorization of the score. This is the function used to plot the distributions of disability scores resulting from the WHO Model Disability Survey.
}
\examples{
fig_density(df_adults, score = "disability_score", cutoffs = c(19.1, 34.4, 49.6), 
x_lab = "Disability score")
fig_density(df_adults, score = "disability_score", var_color = "sex", 
cutoffs = c(19.1, 34.4, 49.6), x_lab = "Disability score")
fig_density(df_adults, score = "disability_score", var_color = "sex", 
var_facet = "age_cat",  cutoffs = c(19.1, 34.4, 49.6), x_lab = "Disability score")
}
\seealso{
Other figure functions: 
\code{\link{fig_LID}()},
\code{\link{fig_dist}()},
\code{\link{fig_poppyramid}()}
}
\concept{figure functions}
