% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_recover_flightline_info}
\alias{wbt_recover_flightline_info}
\title{Recover flightline info}
\usage{
wbt_recover_flightline_info(
  input,
  output,
  max_time_diff = 5,
  pt_src_id = FALSE,
  user_data = FALSE,
  rgb = FALSE,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Name of the input LiDAR points.}

\item{output}{Name of the output LiDAR points.}

\item{max_time_diff}{Maximum in-flightline time difference (seconds).}

\item{pt_src_id}{Add flightline information to the point source ID.}

\item{user_data}{Add flightline information to the user data.}

\item{rgb}{Add flightline information to the RGB colour data.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Associates LiDAR points by their flightlines.
}
\keyword{LiDARTools}
