% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyThings.R
\name{undoHistory}
\alias{undoHistory}
\title{Undo/Redo History Buttons}
\usage{
undoHistory(id, value, value_debounce_rate = 500)
}
\arguments{
\item{id}{The module id}

\item{value}{The reactive expression with the values should be saved for the
user's history. This expression can contain arbitrary data and be of any
structure as long as it returns a single value (or list). Each change in
this value is stored, so the module may not work well for storing large
data sets.}

\item{value_debounce_rate}{Debounce rate in milliseconds for the \code{value}
reactive expression. To avoid saving spurious changes in \code{value}, the
expression is debounced. See \code{\link[shiny:debounce]{shiny::debounce()}} for more information.}
}
\value{
The \code{undoHistory()} module returns the currently selected history
item as the user moves through the stack, or \code{NULL} if the last update
was the result of user input. The returned value has the same structure as
the reactive \code{value} passed to \code{undoHistory()}.
}
\description{
This is a simple Shiny module for undo/redo history. The Shiny module accepts
an arbitrary reactive data value. Changes in the state of this reactive value
are tracked and added to the user's history. The user can then repeatedly
undo and redo to walk through this stack. The module returns the current
selected value of the reactive from this historical stack, or \code{NULL} when
the app state was changed by the user. Because this reactive can hold
arbitrary data about the state of the Shiny app, it is up to the app
developer to use the returned current value to update the Shiny apps' inputs
and UI elements.
}
\keyword{internal}
