% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssize.R
\name{ssize}
\alias{ssize}
\title{Determine minimum sample size}
\usage{
ssize(N, ci = 0.95, me = 0.07, p = 0.5)
}
\arguments{
\item{N}{The population size}

\item{ci}{The desired confidence interval (default is 0.95)}

\item{me}{The margin of error (default: +/- 0.07)}

\item{p}{The expected rate of occurrence (default: 0.50)}
}
\value{
Returns the estimated minimum sample size, rounded up to the nearest integer.
}
\description{
\code{ssize} takes a population size and returns a sample size
}
\section{Details}{

\code{ssize} uses a normal approximation of the hypergeomtric distribution approach.
}

\examples{
ssize(1000)
ssize(1000, ci=0.90, p=0.60)
}
