% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/point.R
\name{point}
\alias{point}
\title{Make WKT point objects}
\usage{
point(..., fmt = 16)
}
\arguments{
\item{...}{A GeoJSON-like object representing a Point, LineString, Polygon, MultiPolygon, etc.}

\item{fmt}{Format string which indicates the number of digits to display after the
decimal point when formatting coordinates. Max: 20}
}
\description{
Make WKT point objects
}
\examples{
## empty point
point("empty")
# point("stuff")

## single point
point(-116.4, 45.2)
point(0, 1)

## single point, from data.frame
df <- data.frame(lon=-116.4, lat=45.2)
point(df)

## many points, from a data.frame
ussmall <- us_cities[1:5, ]
df <- data.frame(long = ussmall$long, lat = ussmall$lat)
point(df)

## many points, from a matrix
mat <- matrix(c(df$long, df$lat), ncol = 2)
point(mat)

## single point, from a list
point(list(c(100.0, 3.101)))

## many points, from a list
point(list(c(100.0, 3.101), c(101.0, 2.1), c(3.14, 2.18)))
}
\seealso{
Other R.objects: \code{\link{circularstring}};
  \code{\link{geometrycollection}};
  \code{\link{linestring}}; \code{\link{multilinestring}};
  \code{\link{multipoint}}; \code{\link{multipolygon}};
  \code{\link{polygon}}
}

