% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemspider.R
\name{cs_inchikey_mol}
\alias{cs_inchikey_mol}
\title{Convert a InChIkey to a Molfile}
\usage{
cs_inchikey_mol(inchikey, parse = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{inchikey}{character,  A InChIKey.}

\item{parse}{should the molfile be parsed to a R object?
If \code{FALSE} the raw mol is returned as string.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
If parse = FALSE then a charactersting,
  else a RMol-object (from \code{\link{parse_mol}})
}
\description{
Convert a InChIkey to a Molfile
}
\examples{
\donttest{
# might fail if API is not available
tric_mol <- cs_inchikey_mol('BQJCRHHNABKAKU-KBQPJGBKSA-N')
tric_mol
cs_inchikey_mol('BQJCRHHNABKAKU-KBQPJGBKSA-N',parse = FALSE)
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
\seealso{
\code{\link{parse_mol}} for a description of the Mol R Object.
}

