% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_weather.R
\name{join_weather}
\alias{join_weather}
\title{Join gridded weather data to an event table}
\usage{
join_weather(
  x,
  params,
  time,
  lat_col = "lat",
  lon_col = "lon",
  time_api = c("guess", "hourly", "daily"),
  tz = "UTC",
  roll = c("nearest", "last", "none"),
  roll_max_hours = NULL,
  spatial_mode = c("cluster", "exact", "by_group"),
  group_col = NULL,
  cluster_radius_m = 250,
  site_elevation = c("constant", "auto"),
  elev_constant = 100,
  elev_fun = NULL,
  community = "ag",
  cache_scope = c("user", "project"),
  cache_dir = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{A data.frame/data.table with event rows.}

\item{params}{Character vector of NASA POWER parameter codes (e.g. \code{"T2M"}).}

\item{time}{A single column name containing time (POSIXct/Date/character/numeric) OR
a character vector of column names used to assemble a timestamp (e.g. \code{c("YEAR","MO","DY","HR")}).}

\item{lat_col, lon_col}{Column names for latitude and longitude (decimal degrees).}

\item{time_api}{One of \code{"guess"}, \code{"hourly"}, \code{"daily"}. If \code{"daily"} is chosen
while the input contains time-of-day information, timestamps are downsampled to dates (with a fixed hour).
If \code{"hourly"} is chosen but the input has no time-of-day information, an error is raised.}

\item{tz}{Time zone used to interpret/construct input timestamps (default \code{"UTC"}). Weather is requested
from NASA POWER in UTC.}

\item{roll}{Join behaviour when matching timestamps: \code{"nearest"} (default, recommended), \code{"last"}, or \code{"none"} (exact).
Rolling is applied when joining hourly weather to event times.}

\item{roll_max_hours}{Maximum allowed time distance (hours) for a rolling match. If NULL, a safe default is used:
1 hour for hourly joins and 24 hours for daily joins.}

\item{spatial_mode}{How to reduce many points to representative locations before calling POWER:
\code{"cluster"} (default), \code{"exact"}, or \code{"by_group"}.
Clustering reduces accidental explosion of provider calls and matches POWER's coarse spatial resolution.}

\item{group_col}{Grouping column used when \code{spatial_mode="by_group"}.}

\item{cluster_radius_m}{Clustering radius in meters when \code{spatial_mode="cluster"}.}

\item{site_elevation}{Elevation strategy for POWER calls: \code{"constant"} or \code{"auto"}.
Elevation is resolved for representative locations and becomes part of the cache identity.}

\item{elev_constant}{Constant elevation (meters) used when \code{site_elevation="constant"} and as a fallback for \code{"auto"}.}

\item{elev_fun}{Optional function \code{function(lon, lat, ...)} returning elevation (meters) for representative points.}

\item{community}{Passed to \code{nasapower::get_power()} (e.g. \code{"ag"}).}

\item{cache_scope}{Where to store cache by default: \code{"user"} or \code{"project"}.}

\item{cache_dir}{Optional explicit cache directory. If NULL, determined by \code{cache_scope}.}

\item{verbose}{If TRUE, print progress messages.}

\item{...}{Passed through to \code{nasapower::get_power()}.}
}
\value{
A data.table with weather columns appended. Rows with missing/invalid inputs keep their original values
and receive NA weather.
}
\description{
Attach gridded weather variables from NASA POWER to rows of an event table.
The function:
\itemize{
\item standardizes/validates time input (single timestamp column or multiple time columns),
\item plans efficient provider calls by clustering locations (default) and splitting sparse time ranges,
\item caches downloaded weather segments locally and reuses them,
\item joins weather back to events using exact or rolling joins.
}
}
\seealso{
\code{\link{wj_cache_list}}, \code{\link{wj_cache_clear}}, \code{\link{weatherjoin_options}}
}
