% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rewire.R
\name{dprewire_undirected}
\alias{dprewire_undirected}
\title{Degree preserving rewiring for undirected networks}
\usage{
dprewire_undirected(
  edgelist,
  eta,
  iteration = 200,
  nattempts,
  rewire.history = FALSE
)
}
\arguments{
\item{edgelist}{A two column matrix, each row represents an undirected edge.}

\item{eta}{A matrix generated by \code{wdnet::get_eta_undirected()}.}

\item{iteration}{An integer, number of rewiring iterations, each iteration
consists of \code{nattempts} rewiring attempts.}

\item{nattempts}{An integer, number of rewiring attempts for each iteration.
The default value equals the number of rows in \code{edgelist}.}

\item{rewire.history}{Logical, whether the rewiring history should be
returned.}
}
\value{
Rewired edgelist, assortativity coefficient after each iteration, and
  rewiring history (including the index of sampled edges and rewiring
  result). For each rewiring attempt, two rows are sampled from the
  \code{edgelist}, for example Edge1:\{v_1, v_2\} and Edge2:\{v_3, v_4\}, the
  function try to rewire the sampled edges as \{v_1, v_4\}, \{v_3, v_2\}
  (rewire type 1) or \{v_1, v_3\}, \{v_2, v_4\} (rewire type 2) with
  probability 1/2.
}
\description{
Degree preserving rewiring towards the target structure \code{eta}.
}
\keyword{internal}
