% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iedriver.R
\name{iedriver}
\alias{iedriver}
\title{Start IE driver server}
\usage{
iedriver(port = 4567L, version = "latest", check = TRUE,
  loglevel = c("FATAL", "TRACE", "DEBUG", "INFO", "WARN", "ERROR"),
  verbose = TRUE, retcommand = FALSE, ...)
}
\arguments{
\item{port}{Port to run on}

\item{version}{what version of IE driver server to run. Default = "latest"
which runs the most recent version. To see other version currently
sourced run binman::list_versions("iedriverserver")}

\item{check}{If TRUE check the versions of IE driver available. If
new versions are available they will be downloaded.}

\item{loglevel}{Specifies the log level used by the server. Valid values
are: TRACE, DEBUG, INFO, WARN, ERROR, and FATAL. Defaults to FATAL
if not specified.}

\item{verbose}{If TRUE, include status messages (if any)}

\item{retcommand}{If TRUE return only the command that would be passed
to \code{\link{spawn_process}}}

\item{...}{pass additional options to the driver}
}
\value{
Returns a list with named elements process, output, error, stop
    and log. process is the output from calling \code{\link{spawn_process}}
    output, error and stop are functions calling
    \code{\link{process_read}}, \code{\link{process_read}} with "stderr"
    pipe and \code{\link{process_kill}}  respectively  on process.
    log is a function which returns the contents of the log file.
}
\description{
Start IE driver server
}
\examples{
\dontrun{
ieDrv <- iedriver()
ieDrv$output()
ieDrv$stop()
}
}
