\name{Thresholding}
\alias{Thresholding}
\alias{da.thresh}
\alias{hybrid.thresh}
\alias{manual.thresh}
\alias{sure.thresh}
\alias{universal.thresh}
\alias{universal.thresh.modwt}
\title{Wavelet Shrinkage via Thresholding}
\description{
  Perform wavelet shrinkage using data-analytic, hybrid SURE, manual,
  SURE, or universal thresholding.
}
\usage{
da.thresh(wc, alpha = .05, max.level = 4, verbose = FALSE, return.thresh = FALSE)
hybrid.thresh(wc, max.level = 4, verbose = FALSE, seed = 0)
manual.thresh(wc, max.level = 4, value, hard = TRUE)
sure.thresh(wc, max.level = 4, hard = TRUE)
universal.thresh(wc, max.level = 4, hard = TRUE)
universal.thresh.modwt(wc, max.level = 4, hard = TRUE)
}
\arguments{
  \item{wc}{wavelet coefficients}
  \item{alpha}{level of the hypothesis tests}
  \item{max.level}{maximum level of coefficients to be affected by threshold}
  \item{verbose}{if \code{verbose=TRUE} then information is printed to
    the screen} 
  \item{value}{threshold value (only utilized in \code{manual.thresh})}
  \item{hard}{Boolean value, if \code{hard=F} then soft thresholding is used}
  \item{seed}{sets random seed (only utilized in \code{hybrid.thresh})}
  \item{return.thresh}{if \code{return.thresh=TRUE} then the vector of
    threshold values is returned, otherwise the surviving wavelet
    coefficients are returned}
}
\value{
  The default output is a list structure, the same length as was input,
  containing only those wavelet coefficients surviving the threshold.
}
\details{
  An extensive amount of literature has been written on wavelet
  shrinkage.  The functions here represent the most basic approaches to
  the problem of nonparametric function estimation.  See the references
  for further information.
}
\references{
  Gencay, R., F. Selcuk and B. Whitcher (2001)
  \emph{An Introduction to Wavelets and Other Filtering Methods in
    Finance and Economics},
  Academic Press.

  Ogden, R. T. (1996)
  \emph{Essential Wavelets for Statistical Applications and Data
    Analysis},
  Birkhauser.

  Percival, D. B. and A. T. Walden (2000)
  \emph{Wavelet Methods for Time Series Analysis},
  Cambridge University Press.

  Vidakovic, B. (1999)
  \emph{Statistical Modeling by Wavelets},
  John Wiley \& Sons.
}
%\seealso{}
%\examples{}
\author{B. Whitcher (some code taken from R. Todd Ogden)}
\keyword{ts}
