% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakfind.R
\name{peakfind}
\alias{peakfind}
\title{peakfind}
\usage{
peakfind(x, smooth = TRUE, thres = 0.2, width = 3)
}
\arguments{
\item{x}{is a waveform with a index at the begining mainly to .}

\item{smooth}{is tell whether you want to smooth the waveform to reduce the effect of some obvious noise. Default is TRUE.}

\item{thres}{is to determine if the detected peak is the real peak whose intensity should be higher than threshold*maximum intensity. Default is 0.2.}

\item{width}{width of moving window.Default is 3, must be integer between 1 and n. This parameter ONLY work when the smooth is TRUE.}
}
\value{
return a list contains waveform index, rough estimates of A, u, sig.
}
\description{
The function allows you to roughly estimate A,u,sig parameters will fit in the Gaussian decomposition.
}
\examples{

##import return waveform data
data(return)
ind<-c(1:nrow(return))
return<-data.frame(ind,return)
x<-return[1,] ###must be must be a dataset incluing intensity with index at the beginning.
peakfind(x) ## index, estimated A, u, and sig

##to get accurate estimates of A, u,g, you need to explore your dataset to optimized parameters.
##generally thres affects a lot, assigning smooth to TRUE is preferable in most of cases.
#for the whole dataset
dr<-apply(return,1,peakfind)
####to manage data and store in a data frame.
rpf<-do.call("rbind",lapply(dr,"[[",1))

}
\references{
Tan Zhou, and Sorin C. Popescu, 2017. Bayesian decomposition of full waveform LiDAR data with uncertainty analysis. Remote Sensing of Environment 200 (2017): 43-62.
}
