% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{create_arcs}
\alias{create_arcs}
\title{Create Arcs from Coordinates}
\usage{
create_arcs(coordinates)
}
\arguments{
\item{coordinates}{A matrix or data frame with two columns representing the x and y coordinates of warehouse locations.}
}
\value{
A matrix with columns \code{x_from}, \code{y_from}, \code{x_to}, \code{y_to}, and \code{distance}, representing the arcs of the graph.
}
\description{
This internal function generates a graph representation from a set of warehouse coordinates by creating arcs (edges) between valid points.
}
\details{
The function identifies valid arcs between coordinate pairs based on specific rules:
- Arcs are created only for points that are aligned either horizontally or vertically.
- Horizontal arcs are added only if they are on the warehouse boundaries (e.g., ground level or the top level).
- Vertical arcs are created if there are no intermediate points between the two coordinates in the same column.
- The distance of each arc is calculated based on the Manhattan distance.

The output graph is represented as a matrix, where each row corresponds to an arc and contains:
- \code{x_from}: x-coordinate of the starting point.
- \code{y_from}: y-coordinate of the starting point.
- \code{x_to}: x-coordinate of the ending point.
- \code{y_to}: y-coordinate of the ending point.
- \code{distance}: Length of the arc.
}
