% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checksels.R
\name{checksels}
\alias{checksels}
\title{Check selection data frames}
\usage{
checksels(X, parallel =  1, path = NULL, check.header = FALSE)
}
\arguments{
\item{X}{data frame with the following columns: 1) "sound.files": name of the .wav 
files, 2) "sel": number of the selections, 3) "start": start time of selections, 4) "end": 
end time of selections. The ouptut of \code{\link{manualoc}} or \code{\link{autodetec}} can 
be used as the input data frame.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).
Not available in Windows OS.}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{check.header}{Logical. Controls whether sound file headers correspond to the actual file properties 
(i.e. if is corrupted). This could significantly affect the performance of the function (much slower) particularly 
with long sound files.}
}
\value{
A data frame including the columns in the input data frame (X) and 2 additional columns:
"check.res" (check selections), and "min.n.samples" (the smallest number of samples). Note the number of samples available
in a selection limits the minimum window length (wl argument in other functions) that can be used in batch analyses.
}
\description{
\code{checksels} checks whether selections can be read by subsequent functions.
}
\details{
This function checks 1) if the selections listed in the data frame correspond to .wav files
in the working directory, 2) if the sound files can be read and if so, 3) if the start and end time
of the selections are found within the duration of the sound files. Note that the sound files 
should be in the working directory (or the directory provided in 'path').
This is useful for avoiding errors in dowstream functions (e.g. \code{\link{specan}}, \code{\link{xcorr}}, \code{\link{catalog}}, \code{\link{dfDTW}}). Note that corrupt files can be
fixed using \code{\link{fixwavs}}) ('sox' must be installed to be able to run this function).
}
\examples{
\dontrun{
# First set temporary folder
setwd(tempdir())

# save wav file examples
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "selec.table"))
writeWave(Phae.long1,"Phae.long1.wav")
writeWave(Phae.long2,"Phae.long2.wav")
writeWave(Phae.long3,"Phae.long3.wav")

checksels(X = selec.table)
}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
\seealso{
\code{\link{checkwavs}}
}

