% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_matrix-data.R
\docType{data}
\name{comp_matrix}
\alias{comp_matrix}
\title{Example matrix listing selections to be compared by \code{\link{cross_correlation}}}
\format{
A data frame with 11 rows and 6 variables: \describe{
 \item{sound.files}{recording names}
 \item{channel}{channel in which signal is found}
 \item{selec}{selection numbers within recording}
 \item{start}{start times of selected signal}
 \item{end}{end times of selected signal}
 \item{bottom.freq}{lower limit of frequency range}
 \item{top.freq}{upper limit of frequency range}
}
}
\source{
Marcelo Araya Salas, warbleR
}
\usage{
data(comp_matrix)
}
\description{
\code{comp_matrix} is a character matrix with 2 columns indicating the selections to be compared (column 1 vs column 2) by \code{\link{cross_correlation}}.
}
\details{
A character matrix with 2 columns indicating the selections to be compared (column 1 vs column 2) by \code{\link{cross_correlation}}. The first column contain the ID of the selection, which is given by combining the 'sound.files' and 'selec' columns of 'X', separated by '-' (i.e. \code{paste(X$sound.files, X$selec, sep = "-")}). The selection id's refer to those on the example data "lbh_selec_table". The second column refers to the sound files in which to search for the templates.
}
\keyword{datasets}
