% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrograms.R
\name{spectrograms}
\alias{spectrograms}
\title{Spectrograms of selected signals}
\usage{
spectrograms(
  X,
  wl = 512,
  flim = "frange",
  wn = "hanning",
  pal = reverse.gray.colors.2,
  ovlp = 70,
  inner.mar = c(5, 4, 4, 2),
  outer.mar = c(0, 0, 0, 0),
  picsize = 1,
  res = 100,
  cexlab = 1,
  propwidth = FALSE,
  xl = 1,
  osci = FALSE,
  gr = FALSE,
  sc = FALSE,
  line = TRUE,
  col = "#07889B",
  fill = adjustcolor("#07889B", alpha.f = 0.15),
  lty = 3,
  mar = 0.05,
  it = "jpeg",
  parallel = 1,
  path = NULL,
  pb = TRUE,
  fast.spec = FALSE,
  by.song = NULL,
  sel.labels = "selec",
  title.labels = NULL,
  dest.path = NULL,
  box = TRUE,
  axis = TRUE,
  ...
)
}
\arguments{
\item{X}{'selection_table', 'extended_selection_table' or data frame containing columns for sound file name (sound.files),
selection number (selec), and start and end time of signals (start and end).
'top.freq' and 'bottom.freq' columns are optional. If using an
'extended_selection_table' the sound files are not required (see \code{\link{selection_table}}).}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default
is 512.}

\item{flim}{A numeric vector of length 2 for the frequency limit (in kHz) of
the spectrogram, as in \code{\link[seewave]{spectro}}. The function also
accepts 'frange' (default) which produces spectrograms with a frequency
limit around the range of each signal (adding a 1 kHz margin).}

\item{wn}{Character vector of length 1 specifying window name. Default is
"hanning". See function \code{\link[seewave]{ftwindow}} for more options.}

\item{pal}{A color palette function to be used to assign colors in the
plot, as in \code{\link[seewave]{spectro}}. Default is reverse.gray.colors.2.}

\item{ovlp}{Numeric vector of length 1 specifying the percent overlap between two
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 70.}

\item{inner.mar}{Numeric vector with 4 elements, default is c(5,4,4,2).
Specifies number of lines in inner plot margins where axis labels fall,
with form c(bottom, left, top, right). See \code{\link[graphics]{par}}.}

\item{outer.mar}{Numeric vector with 4 elements, default is c(0,0,0,0).
Specifies number of lines in outer plot margins beyond axis labels, with
form c(bottom, left, top, right). See \code{\link[graphics]{par}}.}

\item{picsize}{Numeric argument of length 1. Controls relative size of
spectrogram. Default is 1. Ignored when propwidth is \code{TRUE}.}

\item{res}{Numeric argument of length 1. Controls image resolution.
Default is 100 (faster) although 300 - 400 is recommended for publication/
presentation quality.}

\item{cexlab}{Numeric vector of length 1 specifying the relative size of axis
labels. See \code{\link[seewave]{spectro}}.}

\item{propwidth}{Logical argument to scale the width of spectrogram
proportionally to duration of the selection. Default is \code{FALSE}.}

\item{xl}{Numeric vector of length 1. A constant by which to scale
spectrogram width if propwidth = \code{TRUE}. Default is 1.}

\item{osci}{Logical argument to add an oscillogram underneath spectrogram, as
in \code{\link[seewave]{spectro}}. Default is \code{FALSE}.}

\item{gr}{Logical argument to add grid to spectrogram. Default is \code{FALSE}.}

\item{sc}{Logical argument to add amplitude scale to spectrogram, default is
\code{FALSE}.}

\item{line}{Logical argument to add lines at start and end times of selection
(or box if bottom.freq and top.freq columns are provided). Default is \code{TRUE}.}

\item{col}{Color of 'line'. Default is "#07889B".}

\item{fill}{Fill color of box around selections. Default is  \code{adjustcolor("#07889B", alpha.f = 0.15)}.}

\item{lty}{Type of 'line' as in \code{\link[graphics]{par}}. Default is 1.}

\item{mar}{Numeric vector of length 1. Specifies the margins adjacent to the start and end points of selections,
dealineating spectrogram limits. Default is 0.05.}

\item{it}{A character vector of length 1 giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{path}{Character string containing the directory path where the sound files are located.
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{fast.spec}{Logical. If \code{TRUE} then image function is used internally to create spectrograms,
which substantially increases performance (much faster), although some options become unavailable,
as collevels, and sc (amplitude scale). This option is indicated for signals with high background noise
levels. Palette colors \code{\link[monitoR:specCols]{gray.1}}, \code{\link[monitoR:specCols]{gray.2}},
\code{\link[monitoR:specCols]{gray.3}}, \code{\link[monitoR:specCols]{topo.1}} and \code{\link[monitoR:specCols]{rainbow.1}}
(which should be imported from the package monitoR) seem to work better with 'fast' spectrograms.
Palette colors \code{\link[monitoR:specCols]{gray.1}}, \code{\link[monitoR:specCols]{gray.2}}, \code{\link[monitoR:specCols]{gray.3}}
offer decreasing darkness levels.}

\item{by.song}{Character string with the column name containing song labels. If
provide a single spectrogram containing all elements for each song will be produce. Note that
the function assumes that each song has a unique label within a sound file. If \code{NULL} (default), spectrograms are produced for single selections.}

\item{sel.labels}{Character string with the name of the column(s) for selection
labeling. Default is 'selec'. Set to \code{NULL} to remove labels.}

\item{title.labels}{Character string with the name(s) of the column(s) to use as title. Default is \code{NULL} (no title). Only sound file and song included if 'by.song' is provided.}

\item{dest.path}{Character string containing the directory path where the image files will be saved.
If \code{NULL} (default) then the folder containing the sound files will be used instead.}

\item{box}{Logical to control if the box around the spectrogram is plotted (see \code{\link[graphics]{box}}). Default is \code{TRUE}.}

\item{axis}{Logical to control if the Y and X axis are of the spectrogram are plotted (see \code{\link[graphics]{box}}). Default is \code{TRUE}.}

\item{...}{Additional arguments to be passed to the internal spectrogram
creating function for customizing graphical output. The function is a modified
version of \code{\link[seewave]{spectro}}, so it takes the same arguments.}
}
\value{
Image files containing spectrograms of the signals listed in the input data frame.
}
\description{
\code{spectrograms} creates spectrograms of signals from selection tables.
}
\details{
This function provides access to batch process of (a modified version of) the \code{\link[seewave]{spectro}} function from the 'seewave' package. The function creates spectrograms for visualization of vocalizations.
Setting inner.mar to c(4,4.5,2,1) and outer.mar to c(4,2,2,1) works well when picsize = 2 or 3.
Title font size, inner.mar and outer.mar (from mar and oma) don't work well when osci or sc = TRUE,
this may take some optimization by the user. Setting 'fast' argument to TRUE significantly increases speed, although
some options become unavailable, as collevels, and sc (amplitude scale). This option is indicated for signals with
high background noise levels.
}
\examples{
{
  # load and save data
  data(list = c("Phae.long1", "Phae.long2", "lbh_selec_table"))
  writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav")) # save sound files
  writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))

  # make spectrograms
  spectrograms(
    X = lbh_selec_table, flim = c(0, 11), res = 300, mar = 0.05,
    wl = 300, path = tempdir()
  )

  # check this folder
  tempdir()
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{track_freq_contour}} for creating spectrograms to visualize
  frequency measurements by \code{\link{spectro_analysis}}, \code{\link{snr_spectrograms}} for
  creating spectrograms to optimize noise margins used in \code{\link{sig2noise}}

Other spectrogram creators: 
\code{\link{color_spectro}()},
\code{\link{freq_DTW}()},
\code{\link{multi_DTW}()},
\code{\link{phylo_spectro}()},
\code{\link{snr_spectrograms}()},
\code{\link{track_freq_contour}()}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr}) and Grace Smith Vidaurre
}
\concept{spectrogram creators}
