% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_element_est.R
\name{by_element_est}
\alias{by_element_est}
\title{Convert a by-song extended selection table to by-element}
\usage{
by_element_est(X, mar = 0.1, pb = FALSE, parallel = 1)
}
\arguments{
\item{X}{object of class 'extended_selection_table' (see \code{\link{selection_table}}).}

\item{mar}{Numeric vector of length 1 specifying the margins (in seconds) 
adjacent to the start and end points of the selections when creating the ''by element' extended 
selection table. Default is 0.1.}

\item{pb}{Logical argument to control progress bar. Default is \code{FALSE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}
}
\value{
A 'by element' extended selection table (see \code{\link{selection_table}}).
}
\description{
\code{by_element_est} converts a by-song extended selection table to by-element.
}
\details{
This function converts extended selection tables in 'by song' format (several selection per wave object) to a 'by element' format (one wave object per selection).
}
\examples{
\dontrun{
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "selec_table"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))
writeWave(Phae.long4, file.path(tempdir(), "Phae.long4.wav")) 

# create extended selection table
by_song_est <- selection_table(lbh_selec_table, path = tempdir(),
 extended = TRUE, by.song = "song", confirm.extended = FALSE)
 
 # conver o by element
 by_element_est <- by_element_est(by_song_est, mar = 0.05)
}
}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{mp32wav}}, \code{\link{fix_wavs}}

Other extended selection table manipulation: 
\code{\link{rename_est_waves}()},
\code{\link{resample_est}()}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
#last modification on nov-9-2022 (MAS)
}
\concept{extended selection table manipulation}
